import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { VesselEntity } from './vessel.entity';

@Injectable()
export class VesselsService {
  constructor(@InjectRepository(VesselEntity) private readonly repo: Repository<VesselEntity>) {}

  findAll() {
    return this.repo.find({ order: { createdAt: 'DESC' } });
  }
  findOne(id: string) {
    return this.repo.findOne({ where: { id } });
  }
  create(data: Partial<VesselEntity>) {
    return this.repo.save(this.repo.create(data));
  }
  async update(id: string, data: Partial<VesselEntity>) {
    await this.repo.update(id, data);
    return this.findOne(id);
  }
  remove(id: string) {
    return this.repo.delete(id);
  }
}


