import { Column, CreateDateColumn, Entity, OneToMany, OneToOne, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';
import { ProfileEntity } from '../profile/profile.entity';
import { PostEntity } from '../posts/post.entity';
import { ConnectionEntity } from '../network/connection.entity';

@Entity('users')
export class UserEntity {
  @PrimaryGeneratedColumn('uuid')
  id!: string;

  @Column({ unique: true })
  email!: string;

  @Column()
  name!: string;

  @Column({ select: false })
  passwordHash!: string;

  @Column({ type: 'enum', enum: ['professional', 'company'], default: 'professional' })
  userType!: 'professional' | 'company';

  @Column({ nullable: true })
  phone?: string;

  @Column({ nullable: true })
  avatarUrl?: string;

  @Column({ default: false })
  isEmailVerified!: boolean;

  @Column({ nullable: true })
  emailVerificationToken?: string;

  @Column({ nullable: true })
  emailVerificationExpires?: Date;

  @Column({ nullable: true })
  passwordResetToken?: string;

  @Column({ nullable: true })
  passwordResetExpires?: Date;

  @CreateDateColumn()
  createdAt!: Date;

  @UpdateDateColumn()
  updatedAt!: Date;

  // Relations
  @OneToOne(() => ProfileEntity, profile => profile.user)
  profile?: ProfileEntity;

  @OneToMany(() => PostEntity, post => post.author)
  posts?: PostEntity[];

  @OneToMany(() => ConnectionEntity, conn => conn.user)
  connections?: ConnectionEntity[];
}


