import { Injectable } from '@nestjs/common';
import { extname } from 'path';
import { v4 as uuidv4 } from 'uuid';

@Injectable()
export class UploadsService {
  generateFilename(originalname: string): string {
    const ext = extname(originalname);
    return `${uuidv4()}${ext}`;
  }

  getImageUrl(filename: string, category: 'avatars' | 'posts' | 'listings'): string {
    return `/uploads/${category}/${filename}`;
  }

  getCvUrl(filename: string): string {
    return `/uploads/cvs/${filename}`;
  }

  validateImageFile(mimetype: string): boolean {
    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
    return allowedTypes.includes(mimetype);
  }

  validateCvFile(mimetype: string): boolean {
    const allowedTypes = ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
    return allowedTypes.includes(mimetype);
  }

  validateFileSize(size: number, maxSizeMB: number): boolean {
    const maxSizeBytes = maxSizeMB * 1024 * 1024;
    return size <= maxSizeBytes;
  }
}
