import { Entity, PrimaryGeneratedColumn, Column, ManyToOne, CreateDateColumn, UpdateDateColumn } from 'typeorm';
import { UserEntity } from '../users/user.entity';
import { PostEntity } from './post.entity';

@Entity('comments')
export class CommentsEntity {
  @PrimaryGeneratedColumn('uuid') id!: string;

  @Column({ type: 'text' }) content!: string;

  @ManyToOne(() => UserEntity, { eager: true, onDelete: 'CASCADE' })
  author!: UserEntity;

  @ManyToOne(() => PostEntity, (post) => post.comments, { onDelete: 'CASCADE' })
  post!: PostEntity;

  @CreateDateColumn() createdAt!: Date;
  @UpdateDateColumn() updatedAt!: Date;
}
