import { Column, CreateDateColumn, Entity, PrimaryGeneratedColumn, UpdateDateColumn } from 'typeorm';

@Entity('news')
export class NewsEntity {
  @PrimaryGeneratedColumn('uuid') id!: string;

  @Column() title!: string;

  @Column({ type: 'text' }) summary!: string;

  @Column() author!: string;

  @Column({ nullable: true }) imageUrl?: string;

  @CreateDateColumn() publishedDate!: Date;
  @UpdateDateColumn() updatedAt!: Date;
}


