import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { NetworkController } from './network.controller';
import { NetworkService } from './network.service';
import { ConnectionEntity } from './connection.entity';
import { FollowerEntity } from './follower.entity';

@Module({
  imports: [TypeOrmModule.forFeature([ConnectionEntity, FollowerEntity])],
  controllers: [NetworkController],
  providers: [NetworkService],
  exports: [NetworkService]
})
export class NetworkModule {}


