import { CreateDateColumn, Entity, ManyToOne, PrimaryGeneratedColumn, Unique } from 'typeorm';
import { UserEntity } from '../users/user.entity';

@Entity('followers')
@Unique(['follower', 'following'])
export class FollowerEntity {
  @PrimaryGeneratedColumn('uuid')
  id!: string;

  @ManyToOne(() => UserEntity, { eager: true })
  follower!: UserEntity;

  @ManyToOne(() => UserEntity, { eager: true })
  following!: UserEntity;

  @CreateDateColumn()
  createdAt!: Date;
}
