import { Column, CreateDateColumn, Entity, ManyToOne, PrimaryGeneratedColumn, Unique, UpdateDateColumn } from 'typeorm';
import { UserEntity } from '../users/user.entity';

@Entity('connections')
@Unique(['user', 'connection'])
export class ConnectionEntity {
  @PrimaryGeneratedColumn('uuid')
  id!: string;

  @ManyToOne(() => UserEntity, { eager: true })
  user!: UserEntity;

  @ManyToOne(() => UserEntity, { eager: true })
  connection!: UserEntity;

  @Column({ 
    type: 'enum', 
    enum: ['pending', 'accepted', 'rejected'],
    default: 'pending'
  })
  status!: 'pending' | 'accepted' | 'rejected';

  @CreateDateColumn()
  createdAt!: Date;

  @UpdateDateColumn()
  updatedAt!: Date;
}


