import { Module } from '@nestjs/common';
import { TypeOrmModule } from '@nestjs/typeorm';
import { MessagesController } from './messages.controller';
import { MessagesService } from './messages.service';
import { MessageEntity } from './message.entity';
import { ConnectionEntity } from '../network/connection.entity';

@Module({
  imports: [TypeOrmModule.forFeature([MessageEntity, ConnectionEntity])],
  controllers: [MessagesController],
  providers: [MessagesService],
  exports: [MessagesService]
})
export class MessagesModule {}
