import { Body, Controller, Get, Param, Patch, Post, Req, UseGuards } from '@nestjs/common';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';
import { MessagesService } from './messages.service';

@Controller('messages')
@UseGuards(JwtAuthGuard)
export class MessagesController {
  constructor(private readonly messagesService: MessagesService) {}

  @Get('conversations')
  getConversations(@Req() req: any) {
    return this.messagesService.getConversations(req.user.userId);
  }

  @Get('conversation/:userId')
  getConversation(@Req() req: any, @Param('userId') otherUserId: string) {
    return this.messagesService.getConversation(req.user.userId, otherUserId);
  }

  @Post('send')
  sendMessage(
    @Req() req: any,
    @Body() body: { recipientId: string; content: string }
  ) {
    return this.messagesService.sendMessage(
      req.user.userId,
      body.recipientId,
      body.content
    );
  }

  @Patch(':messageId/read')
  markAsRead(@Req() req: any, @Param('messageId') messageId: string) {
    return this.messagesService.markAsRead(messageId, req.user.userId);
  }

  @Patch('conversation/:userId/read')
  markConversationAsRead(@Req() req: any, @Param('userId') otherUserId: string) {
    return this.messagesService.markConversationAsRead(req.user.userId, otherUserId);
  }
}
