import { Injectable } from '@nestjs/common';
import { InjectRepository } from '@nestjs/typeorm';
import { Repository } from 'typeorm';
import { ListingEntity } from './listing.entity';

@Injectable()
export class ListingsService {
  constructor(
    @InjectRepository(ListingEntity)
    private readonly repo: Repository<ListingEntity>
  ) {}

  findAll() {
    return this.repo.find({ order: { createdAt: 'DESC' } });
  }

  findOne(id: string) {
    return this.repo.findOne({ where: { id } });
  }

  findByCompany(companyId: string) {
    return this.repo.find({
      where: { company: { id: companyId } },
      order: { createdAt: 'DESC' }
    });
  }

  create(data: Partial<ListingEntity>) {
    return this.repo.save(this.repo.create(data));
  }

  async update(id: string, data: Partial<ListingEntity>) {
    await this.repo.update(id, data);
    return this.findOne(id);
  }

  remove(id: string) {
    return this.repo.delete(id);
  }
}
