import { Body, Controller, Delete, Get, Param, Patch, Post, UseGuards } from '@nestjs/common';
import { JwtAuthGuard } from '../auth/jwt-auth.guard';
import { ListingsService } from './listings.service';

@Controller('listings')
@UseGuards(JwtAuthGuard)
export class ListingsController {
  constructor(private readonly listingsService: ListingsService) {}

  @Get()
  getListings() {
    return this.listingsService.findAll();
  }

  @Get(':id')
  getListing(@Param('id') id: string) {
    return this.listingsService.findOne(id);
  }

  @Get('company/:id')
  getCompanyListings(@Param('id') companyId: string) {
    return this.listingsService.findByCompany(companyId);
  }

  @Post()
  create(@Body() body: any) {
    return this.listingsService.create(body);
  }

  @Patch(':id')
  update(@Param('id') id: string, @Body() body: any) {
    return this.listingsService.update(id, body);
  }

  @Delete(':id')
  remove(@Param('id') id: string) {
    return this.listingsService.remove(id);
  }
}
