import { Module } from '@nestjs/common';
import { ServeStaticModule } from '@nestjs/serve-static';
import { join } from 'path';
import { ConfigModule } from '@nestjs/config';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AuthModule } from './auth/auth.module';
import { DashboardModule } from './dashboard/dashboard.module';
import { JobsModule } from './jobs/jobs.module';
import { MessagesModule } from './messages/messages.module';
import { NetworkModule } from './network/network.module';
import { NewsModule } from './news/news.module';
import { ProfileModule } from './profile/profile.module';
import { VesselsModule } from './vessels/vessels.module';
import { ListingsModule } from './listings/listings.module';
import { UsersModule } from './users/users.module';
import { PostsModule } from './posts/posts.module';

@Module({
  imports: [
    ServeStaticModule.forRoot({
      rootPath: join(process.cwd(), 'uploads'),
      serveRoot: '/uploads'
    }),
    ConfigModule.forRoot({ isGlobal: true }),
    TypeOrmModule.forRootAsync({
      useFactory: () => ({
        type: 'postgres',
        host: process.env.DB_HOST || 'localhost',
        port: parseInt(process.env.DB_PORT || '5432', 10),
        username: process.env.DB_USER || 'postgres',
        password: process.env.DB_PASSWORD || 'postgres',
        database: process.env.DB_NAME || 'linkedblue',
        autoLoadEntities: true,
        synchronize: process.env.TYPEORM_SYNC === 'true'
      })
    }),
    UsersModule,
    AuthModule,
    DashboardModule,
    JobsModule,
    MessagesModule,
    NetworkModule,
    NewsModule,
    ProfileModule,
    VesselsModule,
    ListingsModule,
    PostsModule
  ]
})
export class AppModule {}


