import { store } from '../../store/store.js';
/**
 * EmailJS global SDK config
 * @param {object} options - the EmailJS global SDK config options
 * @param {string} origin - the non-default EmailJS origin
 */
export const init = (options, origin = 'api.emailjs.com') => {
    if (!options)
        return;
    store.publicKey = options.publicKey;
    store.privateKey = options.privateKey;
    store.storageProvider = options.storageProvider;
    store.blockList = options.blockList;
    store.limitRate = options.limitRate;
    store.origin = options.origin || origin;
};
