"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = void 0;
const store_js_1 = require("../../store/store.js");
/**
 * EmailJS global SDK config
 * @param {object} options - the EmailJS global SDK config options
 * @param {string} origin - the non-default EmailJS origin
 */
const init = (options, origin = 'api.emailjs.com') => {
    if (!options)
        return;
    store_js_1.store.publicKey = options.publicKey;
    store_js_1.store.privateKey = options.privateKey;
    store_js_1.store.storageProvider = options.storageProvider;
    store_js_1.store.blockList = options.blockList;
    store_js_1.store.limitRate = options.limitRate;
    store_js_1.store.origin = options.origin || origin;
};
exports.init = init;
