"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendPost = void 0;
const node_https_1 = require("node:https");
const store_js_1 = require("../store/store.js");
const EmailJSResponseStatus_js_1 = require("../models/EmailJSResponseStatus.js");
const sendPost = (data) => {
    const options = {
        host: store_js_1.store.origin,
        path: '/api/v1.0/email/send',
        port: 443,
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
    };
    return new Promise((resolve, reject) => {
        const req = (0, node_https_1.request)(options, (res) => {
            const chunks = [];
            res.on('data', (chunk) => chunks.push(chunk));
            res.on('end', () => {
                const message = Buffer.concat(chunks).toString();
                const responseStatus = new EmailJSResponseStatus_js_1.EmailJSResponseStatus(res.statusCode, message);
                if (res.statusCode === 200) {
                    resolve(responseStatus);
                }
                else {
                    reject(responseStatus);
                }
            });
            res.on('error', (error) => {
                reject(error);
            });
        });
        req.on('error', (error) => {
            reject(error);
        });
        if (data) {
            req.write(data);
        }
        req.end();
    });
};
exports.sendPost = sendPost;
