import { MigrationInterface, QueryRunner } from 'typeorm';

export class AddEmailVerificationFields1700000001000 implements MigrationInterface {
  name = 'AddEmailVerificationFields1700000001000';

  public async up(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(`
      ALTER TABLE "users" 
      ADD COLUMN "isEmailVerified" boolean NOT NULL DEFAULT false,
      ADD COLUMN "emailVerificationToken" varchar,
      ADD COLUMN "emailVerificationExpires" TIMESTAMP,
      ADD COLUMN "passwordResetToken" varchar,
      ADD COLUMN "passwordResetExpires" TIMESTAMP
    `);
  }

  public async down(queryRunner: QueryRunner): Promise<void> {
    await queryRunner.query(`
      ALTER TABLE "users" 
      DROP COLUMN "isEmailVerified",
      DROP COLUMN "emailVerificationToken",
      DROP COLUMN "emailVerificationExpires",
      DROP COLUMN "passwordResetToken",
      DROP COLUMN "passwordResetExpires"
    `);
  }
}