import { UsersService } from './users.service';
export declare class UsersController {
    private readonly usersService;
    constructor(usersService: UsersService);
    getUserById(id: string): Promise<{
        id: string;
        email: string;
        name: string;
        userType: "professional" | "company";
        phone?: string;
        avatarUrl?: string;
        isEmailVerified: boolean;
        emailVerificationToken?: string;
        emailVerificationExpires?: Date;
        passwordResetToken?: string;
        passwordResetExpires?: Date;
        createdAt: Date;
        updatedAt: Date;
        profile?: import("../profile/profile.entity").ProfileEntity;
        posts?: import("../posts/post.entity").PostEntity[];
        connections?: import("../network/connection.entity").ConnectionEntity[];
    }>;
    searchCompanies(query: string): Promise<{
        id: string;
        email: string;
        name: string;
        userType: "professional" | "company";
        phone?: string;
        avatarUrl?: string;
        isEmailVerified: boolean;
        emailVerificationToken?: string;
        emailVerificationExpires?: Date;
        passwordResetToken?: string;
        passwordResetExpires?: Date;
        createdAt: Date;
        updatedAt: Date;
        profile?: import("../profile/profile.entity").ProfileEntity;
        posts?: import("../posts/post.entity").PostEntity[];
        connections?: import("../network/connection.entity").ConnectionEntity[];
    }[]>;
    findUsers(email: string, search: string): Promise<{
        id: string;
        email: string;
        name: string;
        userType: "professional" | "company";
        phone?: string;
        avatarUrl?: string;
        isEmailVerified: boolean;
        emailVerificationToken?: string;
        emailVerificationExpires?: Date;
        passwordResetToken?: string;
        passwordResetExpires?: Date;
        createdAt: Date;
        updatedAt: Date;
        profile?: import("../profile/profile.entity").ProfileEntity;
        posts?: import("../posts/post.entity").PostEntity[];
        connections?: import("../network/connection.entity").ConnectionEntity[];
    } | {
        id: string;
        email: string;
        name: string;
        userType: "professional" | "company";
        phone?: string;
        avatarUrl?: string;
        isEmailVerified: boolean;
        emailVerificationToken?: string;
        emailVerificationExpires?: Date;
        passwordResetToken?: string;
        passwordResetExpires?: Date;
        createdAt: Date;
        updatedAt: Date;
        profile?: import("../profile/profile.entity").ProfileEntity;
        posts?: import("../posts/post.entity").PostEntity[];
        connections?: import("../network/connection.entity").ConnectionEntity[];
    }[]>;
}
