"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UploadsService = void 0;
const common_1 = require("@nestjs/common");
const path_1 = require("path");
const uuid_1 = require("uuid");
let UploadsService = class UploadsService {
    generateFilename(originalname) {
        const ext = (0, path_1.extname)(originalname);
        return `${(0, uuid_1.v4)()}${ext}`;
    }
    getImageUrl(filename, category) {
        return `/uploads/${category}/${filename}`;
    }
    getCvUrl(filename) {
        return `/uploads/cvs/${filename}`;
    }
    validateImageFile(mimetype) {
        const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
        return allowedTypes.includes(mimetype);
    }
    validateCvFile(mimetype) {
        const allowedTypes = ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
        return allowedTypes.includes(mimetype);
    }
    validateFileSize(size, maxSizeMB) {
        const maxSizeBytes = maxSizeMB * 1024 * 1024;
        return size <= maxSizeBytes;
    }
};
exports.UploadsService = UploadsService;
exports.UploadsService = UploadsService = __decorate([
    (0, common_1.Injectable)()
], UploadsService);
//# sourceMappingURL=uploads.service.js.map