"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProfileService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const profile_entity_1 = require("./profile.entity");
const user_entity_1 = require("../users/user.entity");
const connection_entity_1 = require("../network/connection.entity");
const follower_entity_1 = require("../network/follower.entity");
const post_entity_1 = require("../posts/post.entity");
let ProfileService = class ProfileService {
    constructor(profiles, users, connections, followers, posts) {
        this.profiles = profiles;
        this.users = users;
        this.connections = connections;
        this.followers = followers;
        this.posts = posts;
    }
    findByUserId(userId) {
        return this.profiles.findOne({ where: { user: { id: userId } } });
    }
    async upsert(userId, data) {
        const user = await this.users.findOneOrFail({ where: { id: userId } });
        let profile = await this.findByUserId(userId);
        if (!profile) {
            profile = this.profiles.create({ user, ...data });
        }
        else {
            Object.assign(profile, data);
        }
        return this.profiles.save(profile);
    }
    async getProfileStats(userId) {
        const [connectionsCount, followersCount, followingCount, postsCount] = await Promise.all([
            this.connections.count({
                where: [
                    { user: { id: userId }, status: 'accepted' },
                    { connection: { id: userId }, status: 'accepted' }
                ]
            }),
            this.followers.count({
                where: { following: { id: userId } }
            }),
            this.followers.count({
                where: { follower: { id: userId } }
            }),
            this.posts.count({
                where: { author: { id: userId } }
            })
        ]);
        return {
            connections: connectionsCount,
            followers: followersCount,
            following: followingCount,
            posts: postsCount
        };
    }
    async getProfileWithStats(userId) {
        const user = await this.users.findOne({ where: { id: userId } });
        const profile = await this.findByUserId(userId);
        const stats = await this.getProfileStats(userId);
        return {
            id: user === null || user === void 0 ? void 0 : user.id,
            name: user === null || user === void 0 ? void 0 : user.name,
            email: user === null || user === void 0 ? void 0 : user.email,
            userType: user === null || user === void 0 ? void 0 : user.userType,
            avatarUrl: user === null || user === void 0 ? void 0 : user.avatarUrl,
            phone: user === null || user === void 0 ? void 0 : user.phone,
            ...profile,
            stats
        };
    }
    async updateAvatar(userId, filename) {
        const user = await this.users.findOne({ where: { id: userId } });
        if (!user) {
            throw new Error('User not found');
        }
        user.avatarUrl = `/uploads/avatars/${filename}`;
        await this.users.save(user);
        return this.getProfileWithStats(userId);
    }
};
exports.ProfileService = ProfileService;
exports.ProfileService = ProfileService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(profile_entity_1.ProfileEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.UserEntity)),
    __param(2, (0, typeorm_1.InjectRepository)(connection_entity_1.ConnectionEntity)),
    __param(3, (0, typeorm_1.InjectRepository)(follower_entity_1.FollowerEntity)),
    __param(4, (0, typeorm_1.InjectRepository)(post_entity_1.PostEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], ProfileService);
//# sourceMappingURL=profile.service.js.map