import { Repository } from 'typeorm';
import { ProfileEntity } from './profile.entity';
import { UserEntity } from '../users/user.entity';
import { ConnectionEntity } from '../network/connection.entity';
import { FollowerEntity } from '../network/follower.entity';
import { PostEntity } from '../posts/post.entity';
export declare class ProfileService {
    private readonly profiles;
    private readonly users;
    private readonly connections;
    private readonly followers;
    private readonly posts;
    constructor(profiles: Repository<ProfileEntity>, users: Repository<UserEntity>, connections: Repository<ConnectionEntity>, followers: Repository<FollowerEntity>, posts: Repository<PostEntity>);
    findByUserId(userId: string): Promise<ProfileEntity | null>;
    upsert(userId: string, data: Partial<ProfileEntity>): Promise<ProfileEntity>;
    getProfileStats(userId: string): Promise<{
        connections: number;
        followers: number;
        following: number;
        posts: number;
    }>;
    getProfileWithStats(userId: string): Promise<{
        stats: {
            connections: number;
            followers: number;
            following: number;
            posts: number;
        };
        id: string | undefined;
        user?: UserEntity | undefined;
        currentCompany?: string;
        currentRole?: string;
        certifications?: string[];
        skills?: string[];
        experience?: string;
        companyName?: string;
        numberOfEmployees?: number;
        about?: string;
        contactDetails?: {
            phone?: string;
            address?: string;
            website?: string;
        };
        createdAt?: Date | undefined;
        updatedAt?: Date | undefined;
        name: string | undefined;
        email: string | undefined;
        userType: "professional" | "company" | undefined;
        avatarUrl: string | undefined;
        phone: string | undefined;
    }>;
    updateAvatar(userId: string, filename: string): Promise<{
        stats: {
            connections: number;
            followers: number;
            following: number;
            posts: number;
        };
        id: string | undefined;
        user?: UserEntity | undefined;
        currentCompany?: string;
        currentRole?: string;
        certifications?: string[];
        skills?: string[];
        experience?: string;
        companyName?: string;
        numberOfEmployees?: number;
        about?: string;
        contactDetails?: {
            phone?: string;
            address?: string;
            website?: string;
        };
        createdAt?: Date | undefined;
        updatedAt?: Date | undefined;
        name: string | undefined;
        email: string | undefined;
        userType: "professional" | "company" | undefined;
        avatarUrl: string | undefined;
        phone: string | undefined;
    }>;
}
