import { ProfileService } from './profile.service';
import type { Request } from 'express';
export declare class ProfileController {
    private readonly profileService;
    constructor(profileService: ProfileService);
    getProfile(userId: string): Promise<{
        stats: {
            connections: number;
            followers: number;
            following: number;
            posts: number;
        };
        id: string | undefined;
        user?: import("../users/user.entity").UserEntity | undefined;
        currentCompany?: string;
        currentRole?: string;
        certifications?: string[];
        skills?: string[];
        experience?: string;
        companyName?: string;
        numberOfEmployees?: number;
        about?: string;
        contactDetails?: {
            phone?: string;
            address?: string;
            website?: string;
        };
        createdAt?: Date | undefined;
        updatedAt?: Date | undefined;
        name: string | undefined;
        email: string | undefined;
        userType: "professional" | "company" | undefined;
        avatarUrl: string | undefined;
        phone: string | undefined;
    }>;
    getProfileStats(userId: string): Promise<{
        connections: number;
        followers: number;
        following: number;
        posts: number;
    }>;
    updateProfile(userId: string, body: any): Promise<import("./profile.entity").ProfileEntity>;
    testAvatarUpload(userId: string, req: Request, body: any): Promise<{
        message: string;
        userId: string;
        headers: import("http").IncomingHttpHeaders;
    }>;
    uploadAvatar(userId: string, file: Express.Multer.File, req: Request): Promise<{
        stats: {
            connections: number;
            followers: number;
            following: number;
            posts: number;
        };
        id: string | undefined;
        user?: import("../users/user.entity").UserEntity | undefined;
        currentCompany?: string;
        currentRole?: string;
        certifications?: string[];
        skills?: string[];
        experience?: string;
        companyName?: string;
        numberOfEmployees?: number;
        about?: string;
        contactDetails?: {
            phone?: string;
            address?: string;
            website?: string;
        };
        createdAt?: Date | undefined;
        updatedAt?: Date | undefined;
        name: string | undefined;
        email: string | undefined;
        userType: "professional" | "company" | undefined;
        avatarUrl: string | undefined;
        phone: string | undefined;
    }>;
}
