import { PostsService } from "./posts.service";
import type { Request } from "express";
interface JwtRequest extends Request {
    user: {
        userId: string;
        email: string;
        role: string;
    };
}
export declare function storageFactory(folder: string): import("multer").StorageEngine;
export declare class PostsController {
    private readonly postsService;
    constructor(postsService: PostsService);
    list(): Promise<import("./post.entity").PostEntity[]>;
    get(id: string): Promise<import("./post.entity").PostEntity>;
    create(body: any, image: Express.Multer.File | undefined, req: JwtRequest): Promise<{
        id: string;
        content: string;
        imageUrl: string | undefined;
        createdAt: Date;
        updatedAt: Date;
        author: import("../users/user.entity").UserEntity;
    }>;
    update(id: string, body: any, image: Express.Multer.File | undefined, req: JwtRequest): Promise<import("./post.entity").PostEntity>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
    getLikes(postId: string): Promise<import("./likes.entity").LikesEntity[]>;
    likePost(postId: string, req: JwtRequest): Promise<import("./likes.entity").LikesEntity | {
        message: string;
        likeId: string;
    }>;
    unlikePost(postId: string, req: JwtRequest): Promise<{
        message: string;
    }>;
    addComment(postId: string, body: any, req: Request): Promise<import("./comments.entity").CommentsEntity>;
    updateComment(commentId: string, body: any, req: Request): Promise<{
        message: string;
        comment: import("./comments.entity").CommentsEntity;
    }>;
    deleteComment(commentId: string, req: Request): Promise<{
        message: string;
    }>;
    getComments(postId: string): Promise<import("./comments.entity").CommentsEntity[]>;
}
export {};
