"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const connection_entity_1 = require("./connection.entity");
const follower_entity_1 = require("./follower.entity");
let NetworkService = class NetworkService {
    constructor(connectionRepo, followerRepo) {
        this.connectionRepo = connectionRepo;
        this.followerRepo = followerRepo;
    }
    async getConnections(userId) {
        const connections = await this.connectionRepo.find({
            where: [
                { user: { id: userId }, status: 'accepted' },
                { connection: { id: userId }, status: 'accepted' }
            ],
            relations: ['user', 'user.profile', 'connection', 'connection.profile']
        });
        return connections.map(conn => {
            var _a, _b;
            const otherUser = conn.user.id === userId ? conn.connection : conn.user;
            return {
                id: otherUser.id,
                name: otherUser.name,
                email: otherUser.email,
                userType: otherUser.userType,
                avatarUrl: otherUser.avatarUrl,
                currentRole: (_a = otherUser.profile) === null || _a === void 0 ? void 0 : _a.currentRole,
                companyName: (_b = otherUser.profile) === null || _b === void 0 ? void 0 : _b.companyName,
                connectionId: conn.id
            };
        });
    }
    async getSentRequests(userId) {
        const requests = await this.connectionRepo.find({
            where: { user: { id: userId }, status: 'pending' },
            relations: ['connection', 'connection.profile']
        });
        return requests.map(req => ({
            ...req,
            recipient: req.connection,
            recipientId: req.connection.id
        }));
    }
    async getReceivedRequests(userId) {
        const requests = await this.connectionRepo.find({
            where: { connection: { id: userId }, status: 'pending' },
            relations: ['user', 'user.profile']
        });
        return requests.map(req => ({
            ...req,
            sender: req.user,
            senderId: req.user.id
        }));
    }
    async sendConnectionRequest(userId, targetUserId) {
        if (userId === targetUserId) {
            throw new common_1.BadRequestException('Cannot connect with yourself');
        }
        const existing = await this.connectionRepo.findOne({
            where: [
                { user: { id: userId }, connection: { id: targetUserId } },
                { user: { id: targetUserId }, connection: { id: userId } }
            ]
        });
        if (existing) {
            throw new common_1.BadRequestException('Connection request already exists');
        }
        const connection = this.connectionRepo.create({
            user: { id: userId },
            connection: { id: targetUserId },
            status: 'pending'
        });
        const saved = await this.connectionRepo.save(connection);
        const fullConnection = await this.connectionRepo.findOne({
            where: { id: saved.id },
            relations: ['user', 'user.profile', 'connection', 'connection.profile']
        });
        if (!fullConnection) {
            throw new common_1.NotFoundException('Failed to create connection request');
        }
        return {
            ...fullConnection,
            recipient: fullConnection.connection,
            recipientId: fullConnection.connection.id
        };
    }
    async acceptConnection(requestId, userId) {
        var _a, _b;
        const request = await this.connectionRepo.findOne({
            where: { id: requestId },
            relations: ['user', 'user.profile', 'connection', 'connection.profile']
        });
        if (!request) {
            throw new common_1.NotFoundException('Connection request not found');
        }
        if (request.connection.id !== userId) {
            throw new common_1.BadRequestException('Not authorized to accept this request');
        }
        request.status = 'accepted';
        const saved = await this.connectionRepo.save(request);
        return {
            id: saved.user.id,
            name: saved.user.name,
            email: saved.user.email,
            userType: saved.user.userType,
            avatarUrl: saved.user.avatarUrl,
            currentRole: (_a = saved.user.profile) === null || _a === void 0 ? void 0 : _a.currentRole,
            companyName: (_b = saved.user.profile) === null || _b === void 0 ? void 0 : _b.companyName
        };
    }
    async rejectConnection(requestId, userId) {
        const request = await this.connectionRepo.findOne({
            where: { id: requestId }
        });
        if (!request) {
            throw new common_1.NotFoundException('Connection request not found');
        }
        if (request.connection.id !== userId) {
            throw new common_1.BadRequestException('Not authorized to reject this request');
        }
        return this.connectionRepo.delete(requestId);
    }
    async removeConnection(connectionId) {
        const connection = await this.connectionRepo.findOne({
            where: { id: connectionId }
        });
        if (!connection) {
            throw new common_1.NotFoundException('Connection not found');
        }
        return this.connectionRepo.delete(connectionId);
    }
    async followUser(followerId, followingId) {
        if (followerId === followingId) {
            throw new common_1.BadRequestException('Cannot follow yourself');
        }
        const existing = await this.followerRepo.findOne({
            where: {
                follower: { id: followerId },
                following: { id: followingId }
            }
        });
        if (existing) {
            throw new common_1.BadRequestException('Already following this user');
        }
        const follow = this.followerRepo.create({
            follower: { id: followerId },
            following: { id: followingId }
        });
        return this.followerRepo.save(follow);
    }
    async unfollowUser(followerId, followingId) {
        const follow = await this.followerRepo.findOne({
            where: {
                follower: { id: followerId },
                following: { id: followingId }
            }
        });
        if (!follow) {
            throw new common_1.NotFoundException('Follow relationship not found');
        }
        return this.followerRepo.delete(follow.id);
    }
    async getFollowers(userId) {
        const followers = await this.followerRepo.find({
            where: { following: { id: userId } },
            relations: ['follower', 'follower.profile']
        });
        return followers.map(follow => {
            var _a, _b;
            return ({
                id: follow.follower.id,
                name: follow.follower.name,
                email: follow.follower.email,
                userType: follow.follower.userType,
                avatarUrl: follow.follower.avatarUrl,
                currentRole: (_a = follow.follower.profile) === null || _a === void 0 ? void 0 : _a.currentRole,
                companyName: (_b = follow.follower.profile) === null || _b === void 0 ? void 0 : _b.companyName
            });
        });
    }
    async getFollowing(userId) {
        const following = await this.followerRepo.find({
            where: { follower: { id: userId } },
            relations: ['following', 'following.profile']
        });
        return following.map(follow => {
            var _a, _b;
            return ({
                id: follow.following.id,
                name: follow.following.name,
                email: follow.following.email,
                userType: follow.following.userType,
                avatarUrl: follow.following.avatarUrl,
                currentRole: (_a = follow.following.profile) === null || _a === void 0 ? void 0 : _a.currentRole,
                companyName: (_b = follow.following.profile) === null || _b === void 0 ? void 0 : _b.companyName
            });
        });
    }
    async getFollowerCount(userId) {
        return this.followerRepo.count({
            where: { following: { id: userId } }
        });
    }
    async getFollowingCount(userId) {
        return this.followerRepo.count({
            where: { follower: { id: userId } }
        });
    }
};
exports.NetworkService = NetworkService;
exports.NetworkService = NetworkService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(connection_entity_1.ConnectionEntity)),
    __param(1, (0, typeorm_1.InjectRepository)(follower_entity_1.FollowerEntity)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository])
], NetworkService);
//# sourceMappingURL=network.service.js.map