import { Repository } from 'typeorm';
import { ConnectionEntity } from './connection.entity';
import { FollowerEntity } from './follower.entity';
import { UserEntity } from '../users/user.entity';
export declare class NetworkService {
    private readonly connectionRepo;
    private readonly followerRepo;
    constructor(connectionRepo: Repository<ConnectionEntity>, followerRepo: Repository<FollowerEntity>);
    getConnections(userId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
        connectionId: string;
    }[]>;
    getSentRequests(userId: string): Promise<{
        recipient: UserEntity;
        recipientId: string;
        id: string;
        user: UserEntity;
        connection: UserEntity;
        status: "pending" | "accepted" | "rejected";
        createdAt: Date;
        updatedAt: Date;
    }[]>;
    getReceivedRequests(userId: string): Promise<{
        sender: UserEntity;
        senderId: string;
        id: string;
        user: UserEntity;
        connection: UserEntity;
        status: "pending" | "accepted" | "rejected";
        createdAt: Date;
        updatedAt: Date;
    }[]>;
    sendConnectionRequest(userId: string, targetUserId: string): Promise<{
        recipient: UserEntity;
        recipientId: string;
        id: string;
        user: UserEntity;
        connection: UserEntity;
        status: "pending" | "accepted" | "rejected";
        createdAt: Date;
        updatedAt: Date;
    }>;
    acceptConnection(requestId: string, userId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
    }>;
    rejectConnection(requestId: string, userId: string): Promise<import("typeorm").DeleteResult>;
    removeConnection(connectionId: string): Promise<import("typeorm").DeleteResult>;
    followUser(followerId: string, followingId: string): Promise<FollowerEntity>;
    unfollowUser(followerId: string, followingId: string): Promise<import("typeorm").DeleteResult>;
    getFollowers(userId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
    }[]>;
    getFollowing(userId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
    }[]>;
    getFollowerCount(userId: string): Promise<number>;
    getFollowingCount(userId: string): Promise<number>;
}
