import { NetworkService } from './network.service';
export declare class NetworkController {
    private readonly networkService;
    constructor(networkService: NetworkService);
    getConnections(req: any): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
        connectionId: string;
    }[]>;
    getSentRequests(req: any): Promise<{
        recipient: import("../users/user.entity").UserEntity;
        recipientId: string;
        id: string;
        user: import("../users/user.entity").UserEntity;
        connection: import("../users/user.entity").UserEntity;
        status: "pending" | "accepted" | "rejected";
        createdAt: Date;
        updatedAt: Date;
    }[]>;
    getReceivedRequests(req: any): Promise<{
        sender: import("../users/user.entity").UserEntity;
        senderId: string;
        id: string;
        user: import("../users/user.entity").UserEntity;
        connection: import("../users/user.entity").UserEntity;
        status: "pending" | "accepted" | "rejected";
        createdAt: Date;
        updatedAt: Date;
    }[]>;
    sendConnectionRequest(req: any, targetUserId: string): Promise<{
        recipient: import("../users/user.entity").UserEntity;
        recipientId: string;
        id: string;
        user: import("../users/user.entity").UserEntity;
        connection: import("../users/user.entity").UserEntity;
        status: "pending" | "accepted" | "rejected";
        createdAt: Date;
        updatedAt: Date;
    }>;
    acceptConnection(req: any, requestId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
    }>;
    rejectConnection(req: any, requestId: string): Promise<import("typeorm").DeleteResult>;
    removeConnection(connectionId: string): Promise<import("typeorm").DeleteResult>;
    followUser(req: any, targetUserId: string): Promise<import("./follower.entity").FollowerEntity>;
    unfollowUser(req: any, targetUserId: string): Promise<import("typeorm").DeleteResult>;
    getFollowers(userId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
    }[]>;
    getFollowing(userId: string): Promise<{
        id: string;
        name: string;
        email: string;
        userType: "professional" | "company";
        avatarUrl: string | undefined;
        currentRole: string | undefined;
        companyName: string | undefined;
    }[]>;
}
