"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var EmailService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailService = void 0;
const common_1 = require("@nestjs/common");
const emailjs = require("@emailjs/nodejs");
let EmailService = EmailService_1 = class EmailService {
    constructor() {
        this.logger = new common_1.Logger(EmailService_1.name);
        this.serviceId = process.env.EMAILJS_SERVICE_ID || 'your_service_id';
        this.publicKey = process.env.EMAILJS_PUBLIC_KEY || 'your_public_key';
        this.privateKey = process.env.EMAILJS_PRIVATE_KEY || 'your_private_key';
        this.verificationTemplateId = process.env.EMAILJS_VERIFICATION_TEMPLATE_ID || 'template_verification';
        this.resetTemplateId = process.env.EMAILJS_RESET_TEMPLATE_ID || 'template_reset';
        if (this.privateKey !== 'your_private_key') {
            this.logger.log('Initializing EmailJS with provided credentials...');
            emailjs.init({
                publicKey: this.publicKey,
                privateKey: this.privateKey,
            });
            this.logger.log(`EmailJS initialized - Service: ${this.serviceId}, Templates: ${this.verificationTemplateId}, ${this.resetTemplateId}`);
        }
        else {
            this.logger.warn('EmailJS credentials not found in environment variables. Running in development mode.');
        }
    }
    async sendVerificationEmail(email, otp) {
        try {
            this.logger.log(`Sending verification email to ${email} with OTP: ${otp}`);
            if (this.privateKey === 'your_private_key') {
                this.logger.warn('EmailJS not configured. Using development mode.');
                await new Promise(resolve => setTimeout(resolve, 1000));
                return;
            }
            this.logger.log(`Attempting to send verification email via EmailJS to ${email}...`);
            this.logger.debug(`Using service: ${this.serviceId}, template: ${this.verificationTemplateId}`);
            const templateParams = {
                to_email: email,
                to_name: email.split('@')[0],
                otp_code: otp,
                app_name: 'Linked Blue Ocean',
                expires_in: '10 minutes',
                support_email: 'support@linkedblueocean.com'
            };
            this.logger.debug('Template params:', templateParams);
            const response = await emailjs.send(this.serviceId, this.verificationTemplateId, templateParams);
            this.logger.log(`Verification email sent successfully to ${email}. Response:`, response);
        }
        catch (error) {
            this.logger.error(`Failed to send verification email to ${email}:`, error);
            this.logger.warn(`EmailJS failed, falling back to development mode. OTP for ${email}: ${otp}`);
        }
    }
    async sendPasswordResetEmail(email, otp) {
        try {
            this.logger.log(`Sending password reset email to ${email} with OTP: ${otp}`);
            if (this.privateKey === 'your_private_key') {
                this.logger.warn('EmailJS not configured. Using development mode.');
                await new Promise(resolve => setTimeout(resolve, 1000));
                return;
            }
            this.logger.log(`Attempting to send password reset email via EmailJS to ${email}...`);
            this.logger.debug(`Using service: ${this.serviceId}, template: ${this.resetTemplateId}`);
            const templateParams = {
                to_email: email,
                to_name: email.split('@')[0],
                otp_code: otp,
                app_name: 'Linked Blue Ocean',
                expires_in: '10 minutes',
                support_email: 'support@linkedblueocean.com'
            };
            this.logger.debug('Template params:', templateParams);
            const response = await emailjs.send(this.serviceId, this.resetTemplateId, templateParams);
            this.logger.log(`Password reset email sent successfully to ${email}. Response:`, response);
        }
        catch (error) {
            this.logger.error(`Failed to send password reset email to ${email}:`, error);
            this.logger.warn(`EmailJS failed, falling back to development mode. OTP for ${email}: ${otp}`);
        }
    }
};
exports.EmailService = EmailService;
exports.EmailService = EmailService = EmailService_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [])
], EmailService);
//# sourceMappingURL=email.service.js.map