import { JwtService } from '@nestjs/jwt';
import { UsersService } from '../users/users.service';
import { LoginDto } from './dto/login.dto';
import { RegisterDto } from './dto/register.dto';
import { VerifyEmailDto } from './dto/verify-email.dto';
import { ForgotPasswordDto } from './dto/forgot-password.dto';
import { ResetPasswordDto } from './dto/reset-password.dto';
import { ResendOtpDto } from './dto/resend-otp.dto';
import { EmailService } from './email.service';
export declare class AuthService {
    private readonly usersService;
    private readonly jwtService;
    private readonly emailService;
    constructor(usersService: UsersService, jwtService: JwtService, emailService: EmailService);
    login(dto: LoginDto): Promise<{
        user: {
            id: string | undefined;
            email: string;
            name: string;
            userType: "professional" | "company";
            isEmailVerified: boolean;
        };
        token: string;
    }>;
    register(dto: RegisterDto): Promise<{
        user: {
            id: string;
            email: string;
            name: string;
            userType: "professional" | "company";
            isEmailVerified: boolean;
        };
        message: string;
    }>;
    verifyEmail(dto: VerifyEmailDto): Promise<{
        user: {
            id: string;
            email: string;
            name: string;
            userType: "professional" | "company";
            isEmailVerified: boolean;
        };
        token: string;
        message: string;
    }>;
    resendVerificationOtp(dto: ResendOtpDto): Promise<{
        message: string;
    }>;
    forgotPassword(dto: ForgotPasswordDto): Promise<{
        message: string;
    }>;
    resetPassword(dto: ResetPasswordDto): Promise<{
        message: string;
    }>;
    private generateOTP;
}
