"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const serve_static_1 = require("@nestjs/serve-static");
const path_1 = require("path");
const config_1 = require("@nestjs/config");
const typeorm_1 = require("@nestjs/typeorm");
const auth_module_1 = require("./auth/auth.module");
const dashboard_module_1 = require("./dashboard/dashboard.module");
const jobs_module_1 = require("./jobs/jobs.module");
const messages_module_1 = require("./messages/messages.module");
const network_module_1 = require("./network/network.module");
const news_module_1 = require("./news/news.module");
const profile_module_1 = require("./profile/profile.module");
const vessels_module_1 = require("./vessels/vessels.module");
const listings_module_1 = require("./listings/listings.module");
const users_module_1 = require("./users/users.module");
const posts_module_1 = require("./posts/posts.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            serve_static_1.ServeStaticModule.forRoot({
                rootPath: (0, path_1.join)(process.cwd(), 'uploads'),
                serveRoot: '/uploads'
            }),
            config_1.ConfigModule.forRoot({ isGlobal: true }),
            typeorm_1.TypeOrmModule.forRootAsync({
                useFactory: () => ({
                    type: 'postgres',
                    host: process.env.DB_HOST || 'localhost',
                    port: parseInt(process.env.DB_PORT || '5432', 10),
                    username: process.env.DB_USER || 'postgres',
                    password: process.env.DB_PASSWORD || 'postgres',
                    database: process.env.DB_NAME || 'linkedblue',
                    autoLoadEntities: true,
                    synchronize: process.env.TYPEORM_SYNC === 'true'
                })
            }),
            users_module_1.UsersModule,
            auth_module_1.AuthModule,
            dashboard_module_1.DashboardModule,
            jobs_module_1.JobsModule,
            messages_module_1.MessagesModule,
            network_module_1.NetworkModule,
            news_module_1.NewsModule,
            profile_module_1.ProfileModule,
            vessels_module_1.VesselsModule,
            listings_module_1.ListingsModule,
            posts_module_1.PostsModule
        ]
    })
], AppModule);
//# sourceMappingURL=app.module.js.map