"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateCurrencyEnum1700000001000 = void 0;
class UpdateCurrencyEnum1700000001000 {
    constructor() {
        this.name = 'UpdateCurrencyEnum1700000001000';
    }
    async up(queryRunner) {
        const enumExists = await queryRunner.query(`
            SELECT 1 FROM pg_type WHERE typname = 'jobs_currency_enum'
        `);
        if (enumExists.length > 0) {
            await queryRunner.query(`
                ALTER TYPE "jobs_currency_enum" RENAME TO "jobs_currency_enum_old";
                CREATE TYPE "jobs_currency_enum" AS ENUM(
                    'USD', 'EUR', 'GBP', 'JPY', 'CHF',
                    'CAD', 'MXN',
                    'AUD', 'NZD',
                    'SEK', 'NOK', 'DKK',
                    'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
                    'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
                    'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
                    'BRL', 'ARS', 'CLP', 'COP', 'PEN',
                    'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
                );
                ALTER TABLE "jobs" ALTER COLUMN "currency" TYPE "jobs_currency_enum" USING "currency"::text::"jobs_currency_enum";
                DROP TYPE "jobs_currency_enum_old";
            `);
        }
        else {
            await queryRunner.query(`
                CREATE TYPE "jobs_currency_enum" AS ENUM(
                    'USD', 'EUR', 'GBP', 'JPY', 'CHF',
                    'CAD', 'MXN',
                    'AUD', 'NZD',
                    'SEK', 'NOK', 'DKK',
                    'ZAR', 'NGN', 'EGP', 'KES', 'GHS', 'MAD', 'TND', 'ETB', 'UGX', 'TZS', 'BWP', 'MUR', 'XOF', 'XAF',
                    'CNY', 'INR', 'KRW', 'SGD', 'HKD', 'THB', 'MYR', 'IDR', 'PHP', 'VND',
                    'AED', 'SAR', 'QAR', 'KWD', 'BHD', 'OMR', 'ILS', 'TRY',
                    'BRL', 'ARS', 'CLP', 'COP', 'PEN',
                    'PLN', 'CZK', 'HUF', 'RON', 'RUB', 'UAH'
                );
            `);
        }
    }
    async down(queryRunner) {
        await queryRunner.query(`
            ALTER TYPE "jobs_currency_enum" RENAME TO "jobs_currency_enum_new";
            CREATE TYPE "jobs_currency_enum" AS ENUM('USD', 'EUR', 'GBP', 'CAD', 'AUD', 'JPY', 'CHF', 'SEK', 'NOK', 'DKK');
            ALTER TABLE "jobs" ALTER COLUMN "currency" TYPE "jobs_currency_enum" USING "currency"::text::"jobs_currency_enum";
            DROP TYPE "jobs_currency_enum_new";
        `);
    }
}
exports.UpdateCurrencyEnum1700000001000 = UpdateCurrencyEnum1700000001000;
//# sourceMappingURL=1700000001000-UpdateCurrencyEnum.js.map