@echo off
REM LinkedBlue Backend Deployment Script for Windows
REM This script prepares and deploys the backend application

echo 🚀 LinkedBlue Backend Deployment Script
echo ========================================

REM Check if Node.js is installed
node --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ❌ Node.js is not installed. Please install Node.js v18+ first.
    pause
    exit /b 1
)

echo ✅ Node.js version: 
node --version

REM Check if npm is installed
npm --version >nul 2>&1
if %errorlevel% neq 0 (
    echo ❌ npm is not installed.
    pause
    exit /b 1
)

echo ✅ npm version: 
npm --version

REM Install dependencies
echo 📦 Installing dependencies...
call npm ci --only=production

if %errorlevel% neq 0 (
    echo ❌ Failed to install dependencies
    pause
    exit /b 1
)

echo ✅ Dependencies installed successfully

REM Check if .env file exists
if not exist ".env" (
    echo ⚠️  .env file not found. Please create one based on .env.example
    echo 📋 Required environment variables:
    echo    - PORT
    echo    - DB_HOST, DB_PORT, DB_USER, DB_PASSWORD, DB_NAME
    echo    - JWT_SECRET, JWT_EXPIRES_IN
    echo    - EMAILJS_* variables
    echo.
    echo 💡 Copy .env.example to .env and update the values:
    echo    copy .env.example .env
    pause
    exit /b 1
)

echo ✅ Environment file found

REM Check if dist directory exists
if not exist "dist" (
    echo ❌ Build directory (dist) not found. Please run 'npm run build' first.
    pause
    exit /b 1
)

echo ✅ Build directory found

REM Check if main.js exists
if not exist "dist\src\main.js" (
    echo ❌ Main application file not found. Please run 'npm run build' first.
    pause
    exit /b 1
)

echo ✅ Application build verified

REM Create uploads directory if it doesn't exist
if not exist "uploads" mkdir uploads
if not exist "uploads\avatars" mkdir uploads\avatars
if not exist "uploads\cvs" mkdir uploads\cvs
if not exist "uploads\posts" mkdir uploads\posts
if not exist "uploads\news" mkdir uploads\news

echo ✅ Upload directories created

echo.
echo 🎉 Deployment preparation completed successfully!
echo.
echo 📋 To start the application:
echo    npm run start:prod
echo.
echo 🌐 The application will be available at:
echo    http://localhost:3000 (or your configured PORT)
echo.
echo 📚 API Documentation:
echo    Check DEPLOYMENT_BUILD_SUMMARY.md for available endpoints
echo.
echo 🔧 Troubleshooting:
echo    - Check .env file configuration
echo    - Ensure PostgreSQL is running
echo    - Check logs for any errors
echo    - Verify all environment variables are set

pause