## LinkedBlue Backend (NestJS + PostgreSQL)

Environment variables:

- `PORT` (default: 3000)
- `DB_HOST` (default: localhost)
- `DB_PORT` (default: 5432)
- `DB_USER` (default: postgres)
- `DB_PASSWORD` (default: postgres)
- `DB_NAME` (default: linkedblue)
- `TYPEORM_SYNC` (default: false)
- `JWT_SECRET` (required; dev default ok)
- `JWT_EXPIRES_IN` (default: 7d)

Scripts:

- `npm run start:dev` to develop
- `npm run build && npm run start:prod` to run production build
- `npm run seed` to populate demo data

Base URL: use the same value you configure in your React Native `API_BASE_URL`.

Database connection:

This app uses TypeORM and auto-loads entities. Configure Postgres via env above. In development, you can set `TYPEORM_SYNC=true` to let TypeORM create/update tables automatically. In production, use migrations instead.

Uploads:

- Static files served from `/uploads/*`
- Upload endpoints (multipart/form-data):
  - `POST /profile/:userId/avatar` (field: `avatar`) → returns `{ avatarUrl }`
  - `POST /news/upload` (field: `image`) → returns `{ imageUrl }`
  - `POST /posts/upload` (field: `image`) → returns `{ imageUrl }`

Endpoints:

- Auth: `POST /auth/login`, `POST /auth/register`
- Dashboard: `GET /dashboard` (stats + recent posts)
- Posts (feed): `GET /posts`, `GET /posts/:id`, `POST /posts`, `PATCH /posts/:id`, `DELETE /posts/:id`, `POST /posts/upload`
- News: `GET /news`, `GET /news/:id`, `POST /news`, `PATCH /news/:id`, `DELETE /news/:id`, `POST /news/upload`
- Jobs: `GET /jobs`, `GET /jobs/:id`, `POST /jobs`, `PATCH /jobs/:id`, `DELETE /jobs/:id`
- Vessels: `GET /vessels`, `GET /vessels/:id`, `POST /vessels`, `PATCH /vessels/:id`, `DELETE /vessels/:id`
- Network: `GET /network`, `POST /network`, `DELETE /network/:id`
- Profile: `GET /profile/:userId`, `PATCH /profile/:userId`, `PATCH /profile/:userId/avatar`
- Messages: `GET /messages/:userId/:contactId`, `POST /messages/:userId/:contactId`

Seeding:

1. Ensure database is reachable and (optionally) set `TYPEORM_SYNC=true` for schema creation
2. Run `npm run seed`
3. Seed creates demo users matching your RN mock creds, profiles, posts, jobs, news, vessels, connections, and a message

Auth:

- Bearer JWT in `Authorization` header
- Demo credentials (also seeded):
  - `captain@maritime.com` / `Captain123!`
  - `engineer@shipping.com` / `Engineer456!`
  - `port@manager.com` / `Port789!`


